/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.connect;

import com.ibm.hwmca.fw.logon.LogonValidation;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.tasklet.Tasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.ui.UIStyle;
import com.ibm.hwmca.fw.util.Trace;

public class ConnectServer
extends Tasklet {
    private static final String TRACE_MASKT = "XUCNUIST";
    static final String SERVICE_OPERATION = "operation";
    static final String OPERATION_IS_PASSWORD_EXPIRED = "isPasswordExpired";
    static final String REQUEST_USERID_KEY = "userid";
    static final String RESPONSE_PASSWORD_EXPIRED = "pwexpired";
    static final String OPERATION_GET_USERS_UI = "getUsersUI";
    static final String RESPONSE_UISTYLE_KEY = "uistyle";

    public void init(Object initData) throws TaskletException {
    }

    public void service(TaskletRequest taskletRequest, TaskletResponse taskletResponse) throws TaskletException {
        taskletResponse.noAction();
        if (taskletRequest.isInitialRequest()) {
            return;
        }
        String operation = (String)taskletRequest.getData(SERVICE_OPERATION);
        if (operation == null) {
            throw new TaskletException("Missing operation");
        }
        if (operation.equals(OPERATION_IS_PASSWORD_EXPIRED)) {
            this.isPasswordExpired(taskletRequest, taskletResponse);
        } else if (operation.equals(OPERATION_GET_USERS_UI)) {
            this.getUsersUIStyle(taskletRequest, taskletResponse);
        } else {
            throw new TaskletException("Unknown operation \"" + operation + '\"');
        }
    }

    private void isPasswordExpired(TaskletRequest taskletRequest, TaskletResponse taskletResponse) throws TaskletException {
        String userid = (String)taskletRequest.getData(REQUEST_USERID_KEY);
        if (userid == null) {
            throw new TaskletException("Missing userid");
        }
        User user = User.getUser(userid);
        if (user == null) {
            throw new TaskletException("Unknown user \"" + userid + '\"');
        }
        boolean result = user.isPasswordRulesEnforced() && LogonValidation.GATE_KEEPER.isPasswordExpired(user);
        taskletResponse.setData(RESPONSE_PASSWORD_EXPIRED, result);
    }

    private void getUsersUIStyle(TaskletRequest taskletRequest, TaskletResponse taskletResponse) throws TaskletException {
        String userid = (String)taskletRequest.getData(REQUEST_USERID_KEY);
        if (userid == null) {
            throw new TaskletException("Missing userid");
        }
        User user = User.getUser(userid);
        if (user == null) {
            throw new TaskletException("Unknown user \"" + userid + '\"');
        }
        UIStyle uiStyle = user.getUIStyle();
        Trace.trace(TRACE_MASKT, "User \"" + userid + "\" prefers UI \"" + uiStyle.getIdentifier() + '\"');
        taskletResponse.setData(RESPONSE_UISTYLE_KEY, uiStyle);
    }

    public void logException(Throwable throwable) {
    }
}

